/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.biometric;

import com.zkteco.biometric.FingerprintCaptureThread;
import com.zkteco.biometric.FingerprintSensor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class FingerprintCaptureThreadPool {
    private static Map<String, FingerprintCaptureThread> fingerprintCaptureThreadMap = new HashMap<String, FingerprintCaptureThread>();

    public static void start(FingerprintSensor fingerprintSensor, int index) {
        String threadKey = FingerprintCaptureThreadPool.buildKey(fingerprintSensor, index);
        if (fingerprintCaptureThreadMap.get(threadKey) == null) {
            FingerprintCaptureThread fingerprintCaptureThread = new FingerprintCaptureThread(fingerprintSensor, index);
            new Thread(fingerprintCaptureThread).start();
            fingerprintCaptureThreadMap.put(threadKey, fingerprintCaptureThread);
        } else {
            System.out.println(String.valueOf(threadKey) + " is already running, you don't need to start it once more");
        }
    }

    private static String buildKey(FingerprintSensor fingerprintSensor, int index) {
        return "zkfpsensor." + FingerprintSensor.class.getCanonicalName() + "." + index + "_" + fingerprintSensor.getDeviceTag();
    }

    public static void destroy() {
        Collection<FingerprintCaptureThread> threads = fingerprintCaptureThreadMap.values();
        for (FingerprintCaptureThread thread : threads) {
            thread.cancel();
        }
        fingerprintCaptureThreadMap.clear();
    }

    public static void cancel(FingerprintSensor fingerprintSensor, int index) {
        String threadKey = FingerprintCaptureThreadPool.buildKey(fingerprintSensor, index);
        FingerprintCaptureThread fingerprintCaptureThread = fingerprintCaptureThreadMap.get(threadKey);
        if (fingerprintCaptureThread != null) {
            fingerprintCaptureThread.cancel();
            fingerprintCaptureThreadMap.remove(threadKey);
        } else {
            System.out.println(String.valueOf(threadKey) + " is already cancelled or never running");
        }
    }
}

